VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form frmMain 
   Caption         =   "Thermocouples and an EXP-16"
   ClientHeight    =   5775
   ClientLeft      =   2700
   ClientTop       =   1590
   ClientWidth     =   5985
   LinkTopic       =   "Form1"
   ScaleHeight     =   5775
   ScaleWidth      =   5985
   Begin VB.CommandButton cmdHelp 
      Caption         =   "Help"
      Height          =   615
      Left            =   240
      TabIndex        =   9
      Top             =   3360
      Width           =   2175
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   615
      Left            =   240
      TabIndex        =   8
      Top             =   4320
      Width           =   2175
   End
   Begin VB.Frame Frame1 
      Caption         =   "Thermocouple Type"
      Height          =   855
      Left            =   240
      TabIndex        =   6
      Top             =   2040
      Width           =   1935
      Begin VB.ComboBox Combo1 
         Height          =   315
         Left            =   240
         TabIndex        =   7
         Text            =   "J"
         Top             =   360
         Width           =   855
      End
   End
   Begin VB.ListBox List1 
      Height          =   3375
      Left            =   2880
      TabIndex        =   3
      Top             =   1680
      Width           =   1935
   End
   Begin DlsrLib.DriverLINXSR SRDO 
      Left            =   4440
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SRAI 
      Left            =   5040
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Scan the EXP-16"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   240
      TabIndex        =   1
      Top             =   1080
      Width           =   2175
   End
   Begin VB.Label Label3 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Temperature at the CJC sensor"
      Height          =   255
      Left            =   2880
      TabIndex        =   5
      Top             =   240
      Width           =   2415
   End
   Begin VB.Label Label2 
      Caption         =   "Temperature (degC) at the EXP-16"
      Height          =   255
      Left            =   2880
      TabIndex        =   4
      Top             =   1320
      Width           =   2535
   End
   Begin VB.Label lblCJCTemp 
      BackColor       =   &H00FFFFFF&
      Height          =   375
      Left            =   2880
      TabIndex        =   2
      Top             =   600
      Width           =   1095
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   435
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2085
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim result As Long
Dim calculatedTemp As Single
Dim TCvolts As Single
Dim CJCTemp As Single
Const gain = 100  ' the gain setting of the EXP-16

Private Sub cmdExit_Click()
Form_Unload 0  ' call the code to unload the drivers
End
End Sub

Private Sub cmdHelp_Click()
frmAbout.Show
End Sub

' this example was written for the DAS-1600 Series board used
' with an EXP-16 accessory using DriverLINX and VB6.0 in Win98SE
'
' channel addressing on the EXP-16 is not directly supported by the
' DriverLINX for the DAS-1600 series.
'
' this example uses two SR controls:  one for the AI subsystem and one for
' the DO subsystem.
' the DO bits on the main I/O connector are used to control the channel
' addressing of the EXP accessory
'
' the EXP channel must be selected by setting value on the DO bits (0 to 15)
' and then read the value from analog input channel 0
'
' assumes the EXP is jumpered to feed it's 16 signals into analog input channel 0
' assumes the EXP is jumpered to feed it's CJC signal into analog input channel 1
' assumes the EXP is at a gain of 100
' DAS-1600 must be in 16 Single Ended channel mode for use with an EXP

Private Sub cmdStart_Click()
List1.Clear  ' clear the list box
' read the CJC channel which jumpered at the EXP to feed DAS channel 1
SRAI.Sel_chan_start = 1
SRAI.Refresh  ' read from AI
CJCTemp = SRAI.DLCode2Volts(SRAI.Res_Sta_ioValue)  ' in volts
CJCTemp = CJCTemp / (0.0244) ' CJC on EXP-16 is 24.4 mV per deg C
lblCJCTemp.Caption = Str(Round(CJCTemp, 2)) & " deg C"
' set the bits of the DO channel
' then read from AI channel 0
Dim i As Integer
For i = 0 To 15
SRDO.Res_Sta_ioValue = i  ' set DO bits to values of 0 through 15
SRDO.Refresh
' now read the value from AI channel 0
SRAI.Sel_chan_start = 0  ' read from the DAS channel into which the EXP is sending it's signals
SRAI.Refresh  ' read from AI
'Debug.Print SRAI.Message
TCvolts = SRAI.DLCode2Volts(SRAI.Res_Sta_ioValue) / gain  ' assuming gain of 100 on the EXP
' call a function in the thermcp.dll......
result = Volt2Temp(calculatedTemp, TCvolts, CJCTemp, Asc(Combo1.Text))
' DriverLINX for KPCI boards will install a newer thermcp.dll than what the
' DriverLINX for an ISA board will give you.  The old one distributed with
' ISA boards has a bug in it.  This example program is distributed with
' the newer DLL (build 00.0714), but it must be registed (it is a COM object: DriverLINX
' Thermocouple Library) using regsvr32.  Run the batch file.
If Hex(result) = &H80040154 Then
MsgBox "The Thermcp.dll is not registered on your system.  Please run RegisterDLL.bat"
End If
If result <> 0 Then
List1.AddItem "chan " & Str(i) & " :  " & "out of range"
Else
calculatedTemp = Round(calculatedTemp, 2) ' display two decimal places
List1.AddItem "chan " & Str(i) & " :  " & Str(calculatedTemp)
End If
Next i
'Volt2Temp deals in degrees C
' get the polled mode value from .Res_Sta_ioValue property
' convert it from raw codes to volts using DLCode2Volts

' NOTE:  the DLCode2Volts method is not gain aware.  It always
' assums bipolar gain of 1 at the DAS board.  Use VBArrayBufferConvert to have
' gain aware conversion, or just do math transform on the results
' to take care of your gain other than bipolar and 1

End Sub


Private Sub Form_Load()
' populate the combo box with the supported T/C types
Combo1.AddItem "J"
Combo1.AddItem "K"
Combo1.AddItem "T"
Combo1.AddItem "S"
Combo1.AddItem "B"
Combo1.AddItem "E"
Combo1.AddItem "R"
' set the combo box equal to the first entry
Combo1.ListIndex = 0

With SRAI
.Req_DLL_name = "c:\drvlinx4\kmbdas16.dll"
.Req_device = 0
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
Debug.Print SRAI.Message  ' error check

'now set up polled mode operation SR object

' set up polled mode AI from channel 0
With SRAI
.Req_mode = DL_POLLED
.Req_op = DL_START
.Req_subsystem = DL_AI
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
.Evt_Tim_type = DL_NULLEVENT
.Sel_buf_N = 0
.Sel_chan_N = 1
.Sel_chan_start = 0  ' the 16 EXP channels feed into this DAS-1600 channel
.Sel_chan_startGainCode = .DLGain2Code(-1)
' above is bipolar unity gain
End With

' set the SRDO control to use the same driver as the SRAI since they are
' physically the same board
SRDO.Req_DLL_name = SRAI.Req_DLL_name
SRDO.Req_device = SRAI.Req_device
' no need to do a full init since the DO are on the same board as the AI

'set up a polled mode DO task
With SRDO
.Req_mode = DL_POLLED
.Req_op = DL_START
.Req_subsystem = DL_DO
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
.Evt_Tim_type = DL_NULLEVENT
.Sel_buf_N = 0
.Sel_chan_N = 1
.Sel_chan_start = 0  ' DO channel 0 are the 4 bits on the main I/O connector
End With

End Sub

Private Sub Form_Terminate()
Beep
End Sub

Private Sub Form_Unload(Cancel As Integer)
' unload the drivers for each SR control
SRAI.Req_DLL_name = ""
SRDO.Req_DLL_name = ""
End Sub
